DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `orders_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `customers_cid` varchar(32) DEFAULT NULL,
  `customers_vat_id` varchar(20) DEFAULT NULL,
  `customers_status` int(11) DEFAULT NULL,
  `customers_status_name` varchar(32) NOT NULL DEFAULT '',
  `customers_status_image` varchar(255) DEFAULT NULL,
  `customers_status_discount` decimal(4,2) DEFAULT NULL,
  `customers_name` varchar(64) NOT NULL DEFAULT '',
  `customers_firstname` varchar(64) NOT NULL DEFAULT '',
  `customers_lastname` varchar(64) NOT NULL DEFAULT '',
  `customers_gender` char(1) NOT NULL DEFAULT '',
  `customers_company` varchar(255) DEFAULT NULL,
  `customers_street_address` varchar(64) NOT NULL DEFAULT '',
  `customers_house_number` varchar(64) NOT NULL DEFAULT '',
  `customers_additional_info` VARCHAR(255) NOT NULL DEFAULT '',
  `customers_suburb` varchar(32) DEFAULT NULL,
  `customers_city` varchar(32) NOT NULL DEFAULT '',
  `customers_postcode` varchar(10) NOT NULL DEFAULT '',
  `customers_state` varchar(32) DEFAULT NULL,
  `customers_country` varchar(64) NOT NULL DEFAULT '',
  `customers_telephone` varchar(32) NOT NULL DEFAULT '',
  `customers_email_address` varchar(96) NOT NULL DEFAULT '',
  `customers_address_format_id` int(5) NOT NULL DEFAULT '5',
  `delivery_name` varchar(64) NOT NULL DEFAULT '',
  `delivery_firstname` varchar(64) NOT NULL DEFAULT '',
  `delivery_lastname` varchar(64) NOT NULL DEFAULT '',
  `delivery_gender` char(1) NOT NULL DEFAULT '',
  `delivery_company` varchar(255) DEFAULT NULL,
  `delivery_street_address` varchar(64) NOT NULL DEFAULT '',
  `delivery_house_number` varchar(64) NOT NULL DEFAULT '',
  `delivery_additional_info` VARCHAR(255) NOT NULL DEFAULT '',
  `delivery_suburb` varchar(32) DEFAULT NULL,
  `delivery_city` varchar(32) NOT NULL DEFAULT '',
  `delivery_postcode` varchar(10) NOT NULL DEFAULT '',
  `delivery_state` varchar(32) DEFAULT NULL,
  `delivery_country` varchar(64) NOT NULL DEFAULT '',
  `delivery_country_iso_code_2` char(2) NOT NULL DEFAULT '',
  `delivery_address_format_id` int(5) NOT NULL DEFAULT '5',
  `billing_name` varchar(64) NOT NULL DEFAULT '',
  `billing_firstname` varchar(64) NOT NULL DEFAULT '',
  `billing_lastname` varchar(64) NOT NULL DEFAULT '',
  `billing_gender` char(1) NOT NULL DEFAULT '',
  `billing_company` varchar(255) DEFAULT NULL,
  `billing_street_address` varchar(64) NOT NULL DEFAULT '',
  `billing_house_number` varchar(64) NOT NULL DEFAULT '',
  `billing_additional_info` VARCHAR(255) NOT NULL DEFAULT '',
  `billing_suburb` varchar(32) DEFAULT NULL,
  `billing_city` varchar(32) NOT NULL DEFAULT '',
  `billing_postcode` varchar(10) NOT NULL DEFAULT '',
  `billing_state` varchar(32) DEFAULT NULL,
  `billing_country` varchar(64) NOT NULL DEFAULT '',
  `billing_country_iso_code_2` char(2) NOT NULL DEFAULT '',
  `billing_address_format_id` int(5) NOT NULL DEFAULT '5',
  `payment_method` varchar(32) NOT NULL DEFAULT '',
  `cc_type` varchar(20) DEFAULT NULL,
  `cc_owner` varchar(64) DEFAULT NULL,
  `cc_number` varchar(64) DEFAULT NULL,
  `cc_expires` varchar(4) DEFAULT NULL,
  `cc_start` varchar(4) DEFAULT NULL,
  `cc_issue` char(3) DEFAULT NULL,
  `cc_cvv` varchar(4) DEFAULT NULL,
  `comments` text,
  `last_modified` timestamp NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `date_purchased` datetime DEFAULT NULL,
  `orders_status` int(5) NOT NULL DEFAULT '0',
  `orders_date_finished` datetime DEFAULT NULL,
  `currency` char(3) DEFAULT NULL,
  `currency_value` decimal(13,8) DEFAULT NULL,
  `account_type` int(1) NOT NULL DEFAULT '0',
  `payment_class` varchar(32) NOT NULL DEFAULT '',
  `shipping_method` varchar(255) NOT NULL DEFAULT '',
  `shipping_class` varchar(32) NOT NULL DEFAULT '',
  `order_total_weight` DOUBLE PRECISION(11, 4),
  `customers_ip` varchar(39) NOT NULL DEFAULT '',
  `language` varchar(32) NOT NULL DEFAULT '',
  `afterbuy_success` int(1) NOT NULL DEFAULT '0',
  `afterbuy_id` int(32) NOT NULL DEFAULT '0',
  `refferers_id` varchar(32) NOT NULL DEFAULT '',
  `conversion_type` int(1) NOT NULL DEFAULT '0',
  `orders_ident_key` varchar(128) DEFAULT NULL,
  `gm_orders_id` int(11) DEFAULT NULL,
  `gm_packings_id` int(11) DEFAULT NULL,
  `gm_orders_code` varchar(255) NOT NULL DEFAULT '',
  `gm_packings_code` varchar(255) NOT NULL DEFAULT '',
  `gm_order_html` mediumtext,
  `gm_order_txt` mediumtext,
  `gm_order_send_date` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `gm_send_order_status` int(1) NOT NULL DEFAULT '0',
  `gm_cancel_date` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `abandonment_download` tinyint(1) NOT NULL DEFAULT '0',
  `abandonment_service` tinyint(1) NOT NULL DEFAULT '0',
  `orders_hash` varchar(32) NOT NULL DEFAULT '',
  `exported` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'already exported to WaWi?',
  PRIMARY KEY (`orders_id`),
  UNIQUE KEY `date_purchased_orders_id` (`date_purchased`, `orders_id`),
  KEY `orders_status` (`orders_status`),
  KEY `date_purchased` (`date_purchased`),
  KEY `customers_id` (`customers_id`, `orders_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=400210;
